//////////////////////////////////////////////
// Namespace.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkScriptsTests.Namespace = class Namespace extends nkDebug.TestClass
{
	static instance = new Namespace ("nkScriptsTests.Namespace") ;

	nkTests =
	{
		__testShutdown__ : function ()
		{
			nkScripts.EnvironmentManager.kill() ;
			nkScripts.ScriptManager.kill() ;
		},

		SetBoolVarInNamespaceGood : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			const ns = env.setNamespace("ns") ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = ns.var") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(!env.getVarBool("x", false), "Value mismatch before namespace creation")
			
			ns.setVarBool("var", true) ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarBool("x", false), "Value mismatch after namespace creation")
		},

		SetIntVarInNamespaceGood : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			const ns = env.setNamespace("ns") ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = ns.var") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarInt("x", 0) === 0, "Value mismatch before namespace creation")
			
			ns.setVarInt("var", 5) ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarInt("x", 0) === 5, "Value mismatch after namespace creation")
		},

		SetFloatVarInNamespaceGood : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			const ns = env.setNamespace("ns") ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = ns.var") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarFloat("x", 0) === 0, "Value mismatch before namespace creation")
			
			ns.setVarFloat("var", 5.5) ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarFloat("x", 0) === 5.5, "Value mismatch after namespace creation")
		},

		SetStringVarInNamespaceGood : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			const ns = env.setNamespace("ns") ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = ns.var") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarString("x", "") === "", "Value mismatch before namespace creation")
			
			ns.setVarString("var", "test") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarString("x", "") === "test", "Value mismatch after namespace creation")
		},

		SetNamespaceInNamespaceGoodInLua : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			
			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = ns.ns ; v = x ~= nil ;") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			
			const ns = env.setNamespace("ns") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(!env.getVarBool("v", true), "Value mismatch before namespace creation")
			
			ns.setNamespace("ns") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarBool("v", false), "Value mismatch after namespace creation") ;
		},

		SetFunctionInNamespaceGood : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			
			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = 1 ; v = ns.addToInt(x) ;") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			
			const ns = env.setNamespace("ns") ;
			nkDebug.TestUtils.check(!env.execute(script), "Script should be lacking the method") ;
			
			const f = ns.setFunc("addToInt") ;
			f.addParameter(nkScripts.FUNCTION_PARAMETER_TYPE.FLOAT) ;
			f.setFunction(function (stack) {return new nkScripts.FunctionParameter (stack.get(0)._valFloat + 1)}) ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.areNumbersEqual(env.getVarFloat("v", 0), 2.0, 0.0001, "Value mismatch after namespace creation") ;
		},

		SetNamespacePathGoodInC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			const ns = env.setNamespace("nkScripts.Test") ;

			nkDebug.TestUtils.check(env.isNamespaceSet("nkScripts.Test"), "IsSet failure") ;
			nkDebug.TestUtils.check(ns._ptr === env.getNamespace("nkScripts.Test")._ptr, "Get failure") ;
		},

		SetNamespacePathGoodInLua : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;
			const ns = env.setNamespace("nkScripts.Test") ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("nkScripts.Test.t = 0") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;

			// Good execution means namespace could be indexed
			nkDebug.TestUtils.check(env.execute(script), "Env not found in lua (bad execution)") ;
		}
	}
}